'use strict';

angular.module('genisis').controller('editRequestCtrl', ['$scope', 'request',
  '$rootScope', 'source', 'studyApproval', 'api', 'user',
  '$routeParams', '$window', 'comment', 'focus', '$location',
  'systemAdmin',

  function ($scope, $requests, $rootScope, $sources,
    $studyApprovals, $api, $user, $routeParams,
    $window, $comment, focus, $location, $systemAdmin) {

    $scope.requests = $requests;
    $scope.comment = $comment;
    $scope.request = {};
    $scope.studies = [];
    $scope.studyApprovals = $studyApprovals;
    $scope.sources = $sources;
    $scope.editable = false;
    $scope.canApprove = false;
    $scope.canReturnToRequester = false;
    $scope.copyRequestAble = true;
    $scope.canReturnToDDM = false;
    $scope.commentable = false;
    $scope.commentTypeChangeable = $scope.requests.canChangeCommentType();
    $scope.canCopyTable = false;
    $scope.canAccept = false;
    $scope.canNotBeFulfilled = false;
    $scope.accepted = false;
    $scope.delivered = false;
    $scope.isAdmin = $user.Administrator();
    $scope.logs = [];
    $scope.loadingRequest = true;
    $scope.loadingLogs = true;
    $scope.copyTableEnabled = false;
    $scope.copyingTable = false;
    $scope.copyTableData = {};
    $scope.successCopiedTable = false;
    $scope.failedCopiedTable = false;
    $scope.copyTableMessage = '';
    $scope.selectedStudy = 'Select';


    /**
     * Loads data for a specific request
     * @param int requestID the ID of the request to load
     * @return boolean
     **/
    // $scope.loadRequest = function (requestID) {
    //   //load the request matching the given id
    //   $requests.load().then(function ( /*request*/ ) {
    //     $scope.request = $requests.find(requestID);
    //     $scope.copyRequestAble = $requests.canCopyRequest($scope.request
    //       .statusDescription);
    //     switch ($scope.request.statusDescription) {
    //     case 'Draft':
    //       $scope.editable = true;
    //       $scope.commentable = false;
    //       break;
    //     case 'Returned':
    //       $scope.editable = true;
    //       $scope.commentable = true;
    //       break;
    //     case null:
    //       $scope.editable = false;
    //       break;
    //     case 'Submitted':
    //       if ($user.genisis2Mgr() || $user.Administrator()) {
    //         $scope.submitted = true;
    //       }
    //       $scope.commentable = true;
    //       break;
    //     case 'Sent':
    //       if ($user.vinciMgr() || $user.Administrator()) {
    //         $scope.sent = true;
    //       }
    //       $scope.commentable = true;
    //       break;
    //       // DSM
    //     case 'RequestAccepted':
    //       if ($user.vinciMgr() || $user.Administrator()) {
    //         $scope.accepted = true;
    //       }
    //       break;
    //     case 'ResultsDelivered':
    //       $scope.delivered = true;
    //       $scope.commentable = true;
    //       break;
    //     }
    //
    //     // if ($scope.request.reason !== undefined &&
    //     //   $scope.request.reason !== null) {
    //     //   $rootScope.warnings.push($scope.request.reason);
    //     // }
    //
    //     return true;
    //   });
    // };

    $scope.resetForm = function () {
      $scope.request.comments = null;
    };

    $scope.getDataSources = function () {
      return $api.retrieve('datasources/', {})
        .then(function (dataSource) {
          if (dataSource.success && dataSource.response) {
            if (dataSource.response instanceof Array) {
              $scope.dataSources = dataSource.response;
            } else {
              $scope.dataSources = [dataSource.response];
            }
          } else {
            $window.alert(dataSource.message);
          }
        });
    };

    $scope.requestTypes = function () {
      return $api.retrieve('requestTypes/', {})
        .then(function (requestType) {
          if (requestType.success && requestType.response) {
            if (requestType.response instanceof Array) {
              $scope.requestTypes = requestType.response;
            } else {
              $scope.requestTypes = [requestType.response];
            }
          } else {
            $window.alert(requestType.message);
          }
        });
    };

    $scope.getDescriptionInfo = function (requestType) {
      if (requestType === 1) {
        return $api.retrieve(
            'tooltip/description//VINCI_REQUEST_Description', {})
          .then(function (info) {
            if (info.success && info.response) {
              $window.alert(info.response.textDescription.replace(/ /g,
                '\u00a0').replace(/-/g, '\u2011'));

            } else {
              $window.alert(info.message);
            }
          });
      } else {
        return $api.retrieve(
            'tooltip/description//TRANSFER_TO_VINCI_REQUEST_Description', {}
          )
          .then(function (info) {
            if (info.success && info.response) {
              $window.alert(info.response.textDescription.replace(/ /g,
                '\u00a0').replace(/-/g, '\u2011'));
            } else {
              $window.alert(info.message);
            }
          });
      }
    };

    $scope.getApprovedStudies = function () {
      if ($scope.request.requestTypeId === 1 || !$scope.canEdit($user,
          $scope.request)) {
        $studyApprovals.load().then(function (
          loadedApprovals) {
          $scope.studies = loadedApprovals;
        });
      } else {
        $studyApprovals.loadType2().then(function (
          loadedApprovals) {
          $scope.studies = loadedApprovals;
        });
      }
      $scope.approvedStudies = $scope.studies;
    };

    $scope.getDataTypes = function () {
      return $api.retrieve('dataTypes/', {})
        .then(function (dataType) {
          if (dataType.success && dataType.response) {
            if (dataType.response instanceof Array) {
              $scope.dataTypes = dataType.response;
            } else {
              $scope.dataTypes = [dataType.response];
            }
          } else {
            $window.alert(dataType.message);
          }
        });
    };

    $scope.setStudy = function (study) {
      $scope.selectedStudy = study.title;
      $scope.request.studyApprovalId = study.id;
    };

    $scope.loadRequestByID = function (requestID) {
      $requests.findByID(requestID).then(function (request) {
        if (!$requests.canAccess(request, $user)) {
          $location.path('/requests/' + request.id);
          $window.alert(
            'You are not authorized to access this page.'
          );
        } else {
          $scope.request = request;
          if (request.statusDescription !== 'Draft' && request.statusDescription !==
            'Returned') {
            $studyApprovals.getStudyByID(request).then(function (
              loadedApprovals) {
              $scope.studies = loadedApprovals;
            });
          } else {
            if ($scope.request.requestTypeId === 1) {
              $studyApprovals.load().then(function (
                loadedApprovals) {
                $scope.studies = loadedApprovals;
              });
            } else {
              $studyApprovals.loadType2().then(function (
                loadedApprovals) {
                $scope.studies = loadedApprovals;
              });
            }
          }
          $scope.request.commentType = $comment.getCommentTypeByUser(
            $user);
          $scope.generalIsChecked = $scope.getSelectedCommentType(2);
          $scope.operationIsChecked = $scope.getSelectedCommentType(1);
          $scope.copyRequestAble = $requests.canCopyRequest($scope.request);
          $scope.canReturnToDDM = $requests.canReturnToDDM($scope.request);
          if (request.requestTypeId === 1) {
            switch ($scope.request.statusDescription) {
            case 'Draft':
              $scope.editable = true;
              $scope.commentable = false;
              break;
            case 'Returned':
              if ($scope.canEdit($user, request)) {
                $scope.editable = true;
              } else {
                $scope.editable = false;
              }
              $scope.commentable = true;
              break;
            case null:
              $scope.editable = false;
              break;
            case 'Submitted':
              if ($user.genisis2Mgr() || $user.Administrator()) {
                $scope.canApprove = true;
                $scope.canReturnToRequester = true;
              }
              $scope.commentable = true;
              break;
            case 'Sent':
              if ($user.vinciMgr() || $user.Administrator()) {
                $scope.canAccept = true;
                $scope.canNotBeFulfilled = true;
                $scope.commentable = true;
              }
              break;
            case 'RequestAccepted':
              if ($user.vinciMgr() || $user.Administrator()) {
                $scope.accepted = true;
                $scope.commentable = true;
              }
              break;
            case 'ResultsDelivered':
              if ($user.genisis2Mgr() || $user.Administrator()) {
                $scope.delivered = true;
                $scope.setTableCopy(request);
                $scope.commentable = true;
              }
              break;
            }
          }
          // To VINCI request
          else if (request.requestTypeId === 2) {
            switch ($scope.request.statusDescription) {
            case 'Draft':
              $scope.editable = true;
              $scope.commentable = false;
              break;
            case 'Returned':
              if ($scope.canEdit($user, request)) {
                $scope.editable = true;
              } else {
                $scope.editable = false;
              }
              $scope.commentable = true;
              break;
            case null:
              $scope.editable = false;
              break;
            case 'Submitted':
              if ($user.genisis2Mgr() || $user.Administrator()) {
                $scope.canAccept = true;
                $scope.canReturnToRequester = true;
              }
              $scope.commentable = true;
              break;
            case 'Sent':
              if ($user.vinciMgr() || $user.Administrator()) {
                $scope.canAccept = false;
                $scope.canNotBeFulfilled = false;
                $scope.commentable = true;
              }
              break;
            case 'RequestAccepted':
              if ($user.genisis2Mgr() || $user.Administrator()) {
                $scope.accepted = true;
                $scope.setTableCopy(request);
                $scope.commentable = true;
              }
              break;
            case 'ResultsDelivered':
              if ($user.vinciMgr() || $user.Administrator()) {
                $scope.delivered = true;
                $scope.setTableCopy(request);
                $scope.commentable = true;
              }
              break;
            }
          }

          if ($location.search().created === 'true') {
            $window.alert('Request created successfully.');
          }

          // if ($scope.request.reason !== undefined &&
          //   $scope.request.reason !== null) {
          //   $rootScope.warnings.push($scope.request.reason);
          // }

          $scope.loadingRequest = false;

          $scope.setCommentability(request);

          return true;
        }
      });
    };

    $scope.loadLogs = function (requestID, userRole) {

      //load the logs for this request
      $requests.logs(requestID, userRole).then(function (logData) {
        $scope.logs = $requests.parseLogs(logData);
        if ($scope.logs) {
          $scope.loadingLogs = false;
        }

      });
    };

    //load the request matching the given id
    //  $scope.studies = $studyApprovals.load();

    /**
     * Save updates made to a request
     * @param Object request
     * @return boolean
     **/
    $scope.saveRequest = function (req) {

      //clear any existing errors
      $rootScope.errors = [];
      $rootScope.messages = [];

      if ($requests.exceededMaxCharacters(req.title, 'title')) {
        $window.alert('Title exceeds 256 characters');
        return false;
      }

      if ($requests.exceededMaxCharacters(req.description)) {
        // $rootScope.errors.push(
        //   'Description exceeds 3000 characters'
        // );

        $window.alert('Description exceeds 3000 characters');

        return false;
      }

      if (!$requests.valid(req)) {
        $window.alert('Please fill and select required fields');
        return false;
      }

      return $api.update('requests/' + req.id, {
        data: req
      }).then(function (request) {

        if (request.success && request.response) {
          // $rootScope.messages.push('Your changes have been saved.');
          $window.alert('Your changes have been saved.');
          return true;
        } else {
          // $rootScope.errors.push('Save request API call failed.');
          $api.errorAlert();
        }

        return false;
      });
    };

    /**
     * Submitting a request to the data manager
     * @param Object request data
     * @return boolean
     **/
    $scope.submitRequest = function (req) {

      //clear any existing errors
      $rootScope.errors = [];
      $rootScope.messages = [];

      if ($requests.exceededMaxCharacters(req.title, 'title')) {
        $window.alert('Title exceeds 256 characters');
        return false;
      }

      if ($requests.exceededMaxCharacters(req.description)) {
        // $rootScope.errors.push(
        //   'Description exceeds 3000 characters'
        // );
        $window.alert('Description exceeds 3000 characters');

        return false;
      }

      if (!$requests.valid(req)) {
        return false;
      }

      if (req.comments && req.comments.length > 0) {
        // $comment.validActionComments(req.commentType);
        if ($comment.initConfirm(req.commentType)) {
          return false;
        }
        req.commentType = $comment.findIdByName('general');
        // if ($comment.initConfirm(req.commentType)) {
        //   return false;
        // }
      }



      return $api.update('requests/' + req.id + '/submit', {
        data: req
      }).then(function (request) {

        if (request.success && request.response) {

          //this is no longer editable
          $scope.editable = false;
          req.statusDescription = 'Submitted';

          //set a message that the request was submitted
          // $rootScope.messages.push(
          //   'Your request has been submitted to your data manager.'
          // );
          $window.alert(
            'Your request has been submitted to your data manager.'
          );

          $scope.loadLogs(request.response.id, $user.permissions());
          $scope.resetForm();

          return true;
        } else {
          // $rootScope.errors.push('Submit request API call failed.');
          $api.errorAlert();
        }

        return false;
      });
    };

    /**
     * Approve a request
     * @param Object request
     * @return boolean
     **/
    $scope.approveRequest = function (req) {

      //clear any existing errors
      $rootScope.errors = [];
      $rootScope.messages = [];

      var data = {
        createdBy: $user.username()
      };

      if ($requests.exceededMaxCharacters(req.comments)) {
        // $rootScope.errors.push(
        //   'Comment exceeds 3000 characters'
        // );

        $window.alert('Comment exceeds 3000 characters');

        return false;
      }

      if (req.comments && req.comments.length > 0) {
        // $comment.validActionComments(req.commentType);
        if ($comment.initConfirm(req.commentType)) {
          return false;
        }
        data.comments = req.comments;
        data.commentType = $comment.findIdByName('general');
        // if ($comment.initConfirm(data.commentType)) {
        //   return false;
        // }
      }

      return $api.update('requests/' + req.id + '/sent', {
        data: data
      }).then(function (request) {

        if (request.success && request.response) {
          // $rootScope.messages.push('The request has been approved.');
          $window.alert('The request has been approved.');
          $scope.editable = false;
          $scope.canApprove = false;
          $scope.canReturnToRequester = false;
          if ($user.vinciMgr() || $user.Administrator()) {
            $scope.canAccept = true;
            $scope.canNotBeFulfilled = true;
          }
          req.statusDescription = 'Sent';

          $scope.loadLogs(request.response.id, $user.permissions());
          $scope.resetForm();

          return true;
        } else {
          // $rootScope.errors.push('Approve request API call failed.');
          $api.errorAlert();
        }

        return false;
      });
    };

    /**
     * Save updates made to a request
     * @param string message why this request is being rejected
     * @param Object request the request that's being returned
     * @return boolean
     **/
    $scope.returnRequest = function (message, req) {

      //clear any existing errors
      $rootScope.errors = [];
      $rootScope.message = [];

      if ($requests.exceededMaxCharacters(message)) {
        // $rootScope.errors.push(
        //   'Comment exceeds 3000 characters'
        // );
        $window.alert('Comment exceeds 3000 characters');

        return false;
      }

      if (!message) {
        // $rootScope.errors.push(
        //   'Enter a reason why you\'re denying this request in ' +
        //   'the comment field.'
        // );

        $window.alert('Enter a reason why you\'re returning this' +
          ' request in the comment field.');

        return false;
      }

      // $comment.validActionComments(req.commentType);
      if ($comment.initConfirm(req.commentType)) {
        return false;
      }
      req.commentType = $comment.findIdByName('general');
      // if ($comment.initConfirm(req.commentType)) {
      //   return false;
      // }

      return $api.update('requests/' + req.id + '/return', {
        data: {
          comments: message,
          commentType: req.commentType,
          createdBy: $user.username()
        }
      }).then(function (request) {

        if (request.success && request.response) {
          // $rootScope.messages.push(
          //   'This request has been returned to the owner.'
          // );
          $window.alert(
            'This request has been returned to the owner.');
          $scope.canApprove = false;
          $scope.canReturnToRequester = false;
          $scope.canAccept = false;
          req.statusDescription = 'Returned';

          $scope.loadLogs(request.response.id, $user.permissions());
          $scope.resetForm();

          return true;
        } else {
          // $rootScope.errors.push('Reject request API call failed.');
          $api.errorAlert();
        }

        return false;
      });
    };

    /**
     * Allow data managers and admins to deny submitted requests
     * @param string message why this request is being denied
     * @param Object request the request that's being denied
     * @return boolean
     **/
    $scope.denyRequest = function (message, req) {

      //clear any existing errors
      $rootScope.errors = [];
      $rootScope.messages = [];

      if ($requests.exceededMaxCharacters(message)) {
        // $rootScope.errors.push(
        //   'Comment exceeds 3000 characters'
        // );

        $window.alert('Comment exceeds 3000 characters');

        return false;
      }

      if (!message) {
        // $rootScope.errors.push(
        //   'Enter a reason why you\'re denying this request in ' +
        //   'the comment field.'
        // );

        $window.alert('Enter a reason why you\'re denying' +
          ' this request in the comment field.');

        return false;
      }

      // $comment.validActionComments(req.commentType);
      if ($comment.initConfirm(req.commentType)) {
        return false;
      }
      req.commentType = $comment.findIdByName('general');
      // if ($comment.initConfirm(req.commentType)) {
      //   return false;
      // }

      return $api.update('requests/' + req.id + '/deny', {
        data: {
          comments: message,
          commentType: req.commentType,
          createdBy: $user.username()
        }
      }).then(function (request) {

        if (request.success && request.response) {
          // $rootScope.messages.push('This request has been denied.');
          $window.alert('This request has been denied.');
          $scope.editable = false;
          $scope.canApprove = false;
          $scope.canReturnToRequester = false;
          $scope.canAccept = false;
          req.statusDescription = 'Denied';

          $scope.loadLogs(request.response.id, $user.permissions());
          $scope.resetForm();

          return true;
        } else {
          // $rootScope.errors.push('Deny request API call failed.');
          $api.errorAlert();
        }

        return false;
      });
    };

    /**
     * Allow data managers to accept data from the data supplier
     * @param Object request the request that's data is being accepted
     * @return boolean
     **/
    $scope.acceptData = function (req) {

      //clear any existing errors
      $rootScope.errors = [];
      $rootScope.messages = [];

      if ($requests.exceededMaxCharacters(req.comments)) {
        // $rootScope.errors.push(
        //   'Comment exceeds 3000 characters'
        // );
        $window.alert('Comment exceeds 3000 characters');

        return false;
      }

      var data = {
        createdBy: $user.username()
      };

      if (req.comments && req.comments.length > 0) {
        // $comment.validActionComments(req.commentType);
        if ($comment.initConfirm(req.commentType)) {
          return false;
        }
        data.comments = req.comments;
        data.commentType = $comment.findIdByName('general');
        // if ($comment.initConfirm(req.commentType)) {
        //   return false;
        // }
      }

      return $api.update('requests/' + req.id + '/acceptdata', {
        data: data
      }).then(function (request) {

        if (request.success && request.response) {
          // $rootScope.messages.push(
          //   'This request\'s data has been accepted.');
          $window.alert('This request\'s data has been accepted.');
          $scope.editable = false;
          $scope.canApprove = false;
          $scope.canReturnToRequester = false;
          $scope.canAccept = false;
          $scope.canNotBeFulfilled = false;
          $scope.accepted = true;
          req.statusDescription = 'RequestAccepted';

          $scope.setTableCopy(request.response);
          $scope.loadLogs(request.response.id, $user.permissions());
          $scope.resetForm();

          return true;
        } else {
          // $rootScope.errors.push(
          //   'Accept data request API call failed.');
          $api.errorAlert();
        }

        return false;
      });
    };

    /**
     * Allow data managers to reject data from the data supplier
     * @param Object request the request that's data is being accepted
     * @return boolean
     **/
    $scope.denyData = function (message, req) {

      //clear any existing errors
      $rootScope.errors = [];
      $rootScope.messages = [];

      if ($requests.exceededMaxCharacters(message)) {
        // $rootScope.errors.push(
        //   'Comment exceeds 3000 characters'
        // );
        $window.alert('Comment exceeds 3000 characters');

        return false;
      }

      if (!message) {
        // $rootScope.errors.push(
        //   'Enter a reason why you\'re denying this request in ' +
        //   'the comment field.'
        // );
        $window.alert(
          'Enter a reason why you\'re denying this request in ' +
          'the comment field.'
        );

        return false;
      }

      // $comment.validActionComments(req.commentType);
      if ($comment.initConfirm(req.commentType)) {
        return false;
      }
      req.commentType = $comment.findIdByName('general');
      // if ($comment.initConfirm(req.commentType)) {
      //   return false;
      // }
      return $api.update('requests/' + req.id + '/denydata', {
        data: {
          comments: message,
          commentType: req.commentType,
          createdBy: $user.username()
        }
      }).then(function (request) {

        if (request.success && request.response) {
          // $rootScope.messages.push(
          //   'This request has been denied because the ' +
          //   'request cannot be fulfilled.');
          $window.alert(
            'This request has been denied because the ' +
            'request cannot be fulfilled.');

          $scope.editable = false;
          $scope.canApprove = false;
          $scope.canReturnToRequester = false;
          $scope.canAccept = false;
          $scope.canNotBeFulfilled = false;
          $scope.accepted = false;

          req.statusDescription = 'RequestNotAccepted';

          $scope.loadLogs(request.response.id, $user.permissions());
          $scope.resetForm();

          return true;
        } else {
          // $rootScope.errors.push('Deny data request API call failed.');
          $api.errorAlert();
        }

        return false;
      });
    };

    $scope.deliverResults = function (message, req) {

      //clear any existing errors
      $rootScope.errors = [];
      $rootScope.messages = [];

      if ($requests.exceededMaxCharacters(message)) {
        // $rootScope.errors.push(
        //   'Comment exceeds 3000 characters'
        // );

        $window.alert('Comment exceeds 3000 characters');

        return false;
      }

      if (!message) {
        // $rootScope.errors.push(
        //   'Enter required information before delivering these results ' +
        //   'in the comment field.'
        // );

        $window.alert(
          'Enter required information before delivering these results ' +
          'in the comment field.'
        );

        return false;
      }

      // $comment.validActionComments(req.commentType);
      if ($comment.initConfirm(req.commentType)) {
        return false;
      }
      req.commentType = $comment.findIdByName('general');
      // if ($comment.initConfirm(req.commentType)) {
      //   return false;
      // }
      return $api.update('requests/' + req.id + '/resultsdelivered', {
        data: {
          comments: message,
          commentType: req.commentType,
          createdBy: $user.username()
        }
      }).then(function (request) {
        if (request.success && request.response) {
          // $rootScope.messages.push(
          //   'Results are delivered.'
          // );
          $window.alert('Results are delivered.');
          if (!$user.vinciMgr() && req.requestTypeId === 1) {
            $scope.delivered = true;
          }
          $scope.accepted = false;
          $scope.canAccept = false;
          $scope.canNotBeFulfilled = false;
          $scope.disableCopyTable();

          req.statusDescription = 'ResultsDelivered';

          $scope.loadLogs(request.response.id, $user.permissions());
          $scope.resetForm();

          if ($user.vinciMgr()) {
            $location.path('/requests');
          }

          return true;
        } else {
          // $rootScope.errors.push(
          //   'Deliver results request API call failed.');
          $api.errorAlert();
        }

        return false;
      });
    };

    $scope.returnToDDM = function (message, req) {
      //clear any existing errors
      $rootScope.errors = [];
      $rootScope.messages = [];

      if ($requests.exceededMaxCharacters(message)) {
        // $rootScope.errors.push(
        //   'Comment exceeds 3000 characters'
        // );

        $window.alert('Comment exceeds 3000 characters');

        return false;
      }

      if (!message) {
        // $rootScope.errors.push(
        //   'Enter required information before delivering these results ' +
        //   'in the comment field.'
        // );

        $window.alert(
          'Enter a reason why you are returning the request' +
          ' in the comment field'
        );

        return false;
      }

      // $comment.validActionComments(req.commentType);
      if ($comment.initConfirm(req.commentType)) {
        return false;
      }
      req.commentType = $comment.findIdByName('general');
      // if ($comment.initConfirm(req.commentType)) {
      //   return false;
      // }
      //This method will send an API response to /requests/ {id}/returnToDDM
      //It will set the request statusDescription to the "Returned to DDM" status
      //it requires comment validation - "'Enter a reason why you are returning the request in the comment field"
      //Comment Type is General
      //clear any existing errors
      return $api.update('requests/' + req.id + '/returntoddm', {
        data: {
          comments: message,
          commentType: req.commentType,
          createdBy: $user.username()
        }
      }).then(function (request) {
        if (request.success && request.response) {
          $window.alert('Returned to DDM.');
          $scope.canReturnToDDM = false;
          $scope.accepted = false;
          $scope.canAccept = false;
          $scope.canNotBeFulfilled = false;
          $scope.disableCopyTable();

          req.statusDescription = 'Submitted';

          $scope.loadLogs(request.response.id, $user.permissions());
          $scope.resetForm();

          if ($user.vinciMgr()) {
            $location.path('/requests');
          }

          return true;
        } else {
          // $rootScope.errors.push(
          //   'Deliver results request API call failed.');
          $api.errorAlert();
        }

        return false;
      });
    };

    /**
     * Allow researcher to accept data from the data supplier
     * @param Object request the request that's data is being confirmed for
     * @return boolean
     **/
    $scope.acceptResults = function (req) {

      //clear any existing errors
      $rootScope.errors = [];
      $rootScope.messages = [];

      if ($requests.exceededMaxCharacters(req.comments)) {
        // $rootScope.errors.push(
        //   'Comment exceeds 3000 characters'
        // );
        $window.alert('Comment exceeds 3000 characters');

        return false;
      }

      var data = {
        createdBy: $user.username()
      };

      if (req.comments && req.comments.length > 0) {
        // $comment.validActionComments(req.commentType);
        if ($comment.initConfirm(req.commentType)) {
          return false;
        }
        data.comments = req.comments;
        data.commentType = $comment.findIdByName('general');
        // if ($comment.initConfirm(req.commentType)) {
        //   return false;
        // }
      }

      return $api.update('requests/' + req.id + '/confirmdata', {
        data: data
      }).then(function (request) {

        if (request.success && request.response) {
          // $rootScope.messages.push(
          //   'This request\'s data has been accepted.'
          // );
          $window.alert(
            'This request\'s data has been accepted.'
          );
          $scope.editable = false;
          $scope.delivered = false;
          $scope.canApprove = false;
          $scope.canReturnToRequester = false;
          $scope.canAccept = false;
          $scope.canNotBeFulfilled = false;
          $scope.accepted = false;
          $scope.disableCopyTable();
          req.statusDescription = 'ResultsAccepted';

          $scope.loadLogs(request.response.id, $user.permissions());
          $scope.resetForm();

          return true;

        } else {
          // $rootScope.errors.push(
          //   'Accept results request API call failed.');
          $api.errorAlert();
        }

        return false;
      });
    };

    /**
     * Allow researcher to reject the data from the data supplier
     * @param Object request the request that's data is being rejected for
     * @return boolean
     **/
    $scope.denyResults = function (message, req) {

      //clear any existing errors
      $rootScope.errors = [];
      $rootScope.messages = [];

      if ($requests.exceededMaxCharacters(message)) {
        // $rootScope.errors.push(
        //   'Comment exceeds 3000 characters'
        // );
        $window.alert('Comment exceeds 3000 characters');

        return false;
      }

      if (!message) {
        // $rootScope.errors.push(
        //   'Enter a reason why you\'re denying this request in ' +
        //   'the comment field.'
        // );

        $window.alert(
          'Enter a reason why you\'re denying this request in ' +
          'the comment field.'
        );

        return false;
      }

      // $comment.validActionComments(req.commentType);
      if ($comment.initConfirm(req.commentType)) {
        return false;
      }
      req.commentType = $comment.findIdByName('general');
      // if ($comment.initConfirm(req.commentType)) {
      //   return false;
      // }
      return $api.update('requests/' + req.id + '/rejectdata', {
        data: {
          comments: message,
          commentType: req.commentType,
          createdBy: $user.username()
        }

      }).then(function (request) {

        if (request.success && request.response) {
          if (req.requestTypeId === 1) {
            $window.alert(
              'This request\'s data has been rejected by the data manager.'

            );
          } else {
            $window.alert(
              'This request data has been rejected by VINCI'
            );

          }

          $scope.editable = false;
          $scope.delivered = false;
          $scope.canApprove = false;
          $scope.canReturnToRequester = false;
          $scope.canAccept = false;
          $scope.canNotBeFulfilled = false;
          $scope.accepted = false;
          $scope.disableCopyTable();

          req.statusDescription = 'ResultsNotAccepted';

          $scope.loadLogs(request.response.id, $user.permissions());
          $scope.resetForm();

          return true;
        } else {
          // $rootScope.errors.push(
          //   'Deny results request API call failed.');
          $api.errorAlert();
        }

        return false;
      });
    };

    $scope.cancelRequest = function (req) {
      //clear any existing errors
      $rootScope.errors = [];
      $rootScope.messages = [];
      var message = req.comments;
      if ($requests.exceededMaxCharacters(message)) {
        $window.alert('Comment exceeds 3000 characters');
        return false;
      }
      if (!message) {
        // $rootScope.errors.push(
        //   'Enter a reason why you\'re denying this request in ' +
        //   'the comment field.'
        // );

        $window.alert('Enter a reason why you\'re cancelling' +
          ' this request in the comment field.');

        return false;
      }

      // $comment.validActionComments(req.commentType);
      if ($comment.initConfirm(req.commentType)) {
        return false;
      }
      req.commentType = $comment.findIdByName('general');
      // if ($comment.initConfirm(req.commentType)) {
      //   return false;
      // }

      var data = {
        createdBy: $user.username(),
        comments: message,
        commentType: req.commentType
      };

      if (req.comments && req.comments.length > 0) {
        if ($comment.initConfirm(req.commentType)) {
          return false;
        }
        data.comments = req.comments;
        data.commentType = $comment.findIdByName('general');
      }
      var confirm = $window.confirm(
        'Are you sure you want to cancel data request ' +
        'Req ' + req.id + ' - ' + req.title + '? Click ' +
        'OK if you want to Cancel the data request or Cancel ' +
        'if you don\'t want Cancel the request.');
      if (confirm) {
        return $api.update('requests/' + req.id + '/cancelled', {
          data: data
        }).then(function (request) {
          if (request.success && request.response) {
            $window.alert(
              'Request ' + request.response.id +
              ' successfully cancelled.'
            );

            $scope.editable = false;
            $scope.delivered = false;
            $scope.canApprove = false;
            $scope.canReturnToRequester = false;
            $scope.canAccept = false;
            $scope.canNotBeFulfilled = false;
            $scope.accepted = false;
            $scope.disableCopyTable();
            $scope.cancellable = false;

            req.statusDescription = 'Cancelled';

            $scope.loadLogs(request.response.id, $user.permissions());
            $scope.resetForm();

            return true;
          } else {
            // $rootScope.errors.push(
            //   'Deny results request API call failed.');
            $api.errorAlert();
          }

          return false;
        });
      }
    };

    $scope.submitComment = function (request) {
      //clear any existing errors
      $rootScope.errors = [];
      $rootScope.messages = [];

      if ($requests.exceededMaxCharacters(request.comments)) {
        // $rootScope.errors.push(
        //   'Comment exceeds 3000 characters'
        // );

        $window.alert('Comment exceeds 3000 characters');

        return false;
      }

      if (!request.comments) {
        // $rootScope.errors.push(
        //   'Please enter a comment and try again.'
        // );

        $window.alert(
          'Please enter a comment and try again.'
        );

        return false;
      }


      if ($comment.validActionComments(request.commentType)) {
        return false;
      }


      return $api.create('comment', {
        data: {
          requestId: request.id,
          status: request.statusDescription,
          comments: request.comments,
          commentType: request.commentType,
          createdBy: $user.username()
        }
      }).then(function (comment) {
        if (comment.success && comment.response) {
          // $rootScope.messages.push(
          //   'Comment posted.'
          // );
          $window.alert('Comment posted');

          $scope.loadLogs(comment.response.requestId, $user.permissions());
          $scope.resetForm();

          return true;
        } else {
          // $rootScope.errors.push(
          //   'Failed to post comment, please try again.'
          // );
          $api.errorAlert();
        }

        return false;
      });
    };

    $scope.requestHistory = function (request) {
      //make sure they have an ID and the request exists
      if (request.id && parseInt(request.id, 10)) {
        $location.path('/requestHistory/' + request.id);
        return true;
      }

      return false;
    };

    $scope.returnToRequestMetrics = function () {
      $systemAdmin.setRequestMetricsTab();
    };

    $scope.setCommentability = function (request) {
      // Is user a Requestor or not?
      var currentStatus = request.statusDescription;
      if ($user.requester()) {
        if (
          currentStatus === 'Submitted' ||
          currentStatus === 'Returned' ||
          currentStatus === 'Denied' ||
          currentStatus === 'RequestNotAccepted' ||
          currentStatus === 'ResultsAccepted' ||
          currentStatus === 'ResultsNotAccepted') {
          $scope.commentable = true;
        } else {
          $scope.commentable = false;
        }
      } else if ($user.genisis2Mgr()) {
        if (currentStatus !== 'Draft') {
          $scope.commentable = true;
        } else {
          $scope.commentable = false;
        }
      } else if ($user.vinciMgr()) {
        if (request.requestTypeId === 1) {
          if (
            currentStatus === 'Sent' ||
            currentStatus === 'RequestAccepted' ||
            currentStatus === 'RequestNotAccepted') {
            $scope.commentable = true;
          } else {
            $scope.commentable = false;
          }
        } else {
          if (
            currentStatus === 'Sent' ||
            currentStatus === 'RequestAccepted' ||
            currentStatus === 'RequestNotAccepted' ||
            currentStatus === 'ResultsDelivered') {
            $scope.commentable = true;
          } else {
            $scope.commentable = false;
          }
        }
      } else if ($user.Administrator()) {
        if (
          currentStatus !== 'Draft'
        ) {
          $scope.commentable = true;
        } else {
          $scope.commentable = false;
        }
      }
    };
    $scope.getCommentability = function (request) {
      // Is user a Requestor or not?
      var currentStatus = request.statusDescription;
      if (request.requestTypeId === 1) {
        if ($user.requester()) {
          if (
            currentStatus === 'Submitted' ||
            currentStatus === 'Denied' ||
            currentStatus === 'RequestNotAccepted' ||
            currentStatus === 'ResultsAccepted' ||
            currentStatus === 'ResultsNotAccepted') {
            return true;
          } else {
            return false;
          }
        } else if ($user.genisis2Mgr()) {
          if (currentStatus !== 'Draft') {
            return true;
          } else {
            return false;
          }
        } else if ($user.vinciMgr()) {
          if (
            currentStatus === 'Sent' ||
            currentStatus === 'RequestAccepted' ||
            currentStatus === 'RequestNotAccepted') {
            return true;
          } else {
            return false;
          }
        } else if ($user.Administrator()) {
          if (
            currentStatus !== 'Draft'
          ) {
            return true;
          } else {
            return false;
          }
        }
      } else {
        if ($user.requester()) {
          if (
            currentStatus === 'Submitted' ||
            currentStatus === 'Denied' ||
            currentStatus === 'Returned' ||
            currentStatus === 'RequestNotAccepted' ||
            currentStatus === 'RequestAccepted' ||
            currentStatus === 'ResultsDelivered' ||
            currentStatus === 'ResultsAccepted' ||
            currentStatus === 'ResultsNotAccepted') {
            return true;
          } else {
            return false;
          }
        } else if ($user.genisis2Mgr()) {
          if (currentStatus !== 'Draft') {
            return true;
          } else {
            return false;
          }
        } else if ($user.vinciMgr()) {
          if (request.requestTypeId === 1) {
            if (
              currentStatus === 'Sent' ||
              currentStatus === 'RequestAccepted' ||
              currentStatus === 'Submitted' ||
              currentStatus === 'Denied' ||
              currentStatus === 'RequestNotAccepted' ||
              currentStatus === 'ResultsAccepted' ||
              currentStatus === 'ResultsNotAccepted') {
              return true;
            } else {
              return false;
            }
          } else {
            if (
              currentStatus === 'Sent' ||
              currentStatus === 'RequestAccepted' ||
              currentStatus === 'Submitted' ||
              currentStatus === 'Returned' ||
              currentStatus === 'Denied' ||
              currentStatus === 'RequestNotAccepted' ||
              currentStatus === 'ResultsAccepted' ||
              currentStatus === 'ResultsNotAccepted' ||
              currentStatus === 'ResultsDelivered') {
              return true;
            } else {
              return false;
            }
          }
        } else if ($user.Administrator()) {
          if (
            currentStatus !== 'Draft'
          ) {
            return true;
          } else {
            return false;
          }
        }
      }
    };

    $scope.setTableCopy = function (request) {
      var currentStatus = request.statusDescription;
      // This will change when we implement DSM / DDM requirements
      if (request.requestTypeId === 1) {
        if (($user.genisis2Mgr() || $user.Administrator()) &&
          currentStatus === 'ResultsDelivered') {
          $scope.canCopyTable = true;
        }
      } else if (request.requestTypeId === 2) {
        if (($user.genisis2Mgr() || $user.Administrator()) &&
          currentStatus === 'RequestAccepted') {
          $scope.canCopyTable = true;
        }
      }
    };

    $scope.enableCopyTable = function () {
      $scope.copyTableEnabled = true;
      // Prefill data for copy table
      return $api.retrieve('copytable/domains', {})
        .then(function (copyTableAuth) {
          $scope.copyTableData = {};
          if (copyTableAuth.success && copyTableAuth.response) {
            $scope.copyTableData = copyTableAuth.response;
          }
        });
    };

    $scope.disableCopyTable = function () {
      $scope.canCopyTable = false;
      $scope.failedCopiedTable = false;
      $scope.successCopiedTable = false;
    };

    $scope.collapseCopyTable = function () {
      $scope.clearCopyTableForm();
      $scope.copyTableEnabled = false;
    };

    $scope.clearCopyTableForm = function () {
      $scope.copyTableData.tableName = null;
      $scope.copyTableData.sourceSchemaName = null;
      $scope.copyTableData.destinationSchemaName = null;
      $scope.copyTableMessage = '';
    };
    $scope.submitCopyTableData = function (copyTableData) {
      $scope.canCopyTable = false;
      $scope.copyingTable = true;

      $rootScope.errors = [];
      $rootScope.messages = [];

      var baseErrorMessage = 'Please enter the following: ';
      var errorsMessage = '';

      if (!copyTableData.tableName) {
        // $rootScope.errors.push('Please enter a table name.');
        errorsMessage += 'Table name; ';
      }

      if (!copyTableData.sourceSchemaName) {
        errorsMessage += 'Source Schema Name; ';
      }

      if (!copyTableData.destinationSchemaName) {
        errorsMessage += 'Destination Schema Name;';
      }

      if (errorsMessage.length > 0) {
        $window.alert(baseErrorMessage + errorsMessage);
        $scope.canCopyTable = true;
        $scope.copyingTable = false;
        return false;
      }

      copyTableData.createdBy = $user.username();

      focus('copying');

      return $api.create('requests/' + $scope.request.id + '/copytable', {
        data: copyTableData
      }).then(function (copytable) {
        $scope.copyingTable = false;
        if (copytable.success && copytable.response) {
          $scope.loadLogs($scope.request.id, $user.permissions());
          $scope.copyTableMessage = copytable.response;
          if (/Successfully/.test(copytable.response)) {
            $scope.successCopiedTable = true;
            $scope.copyTableMessage = copytable.response +
              '. Click here to proceed.';
            focus('success-copy');
          } else {
            $scope.failedCopiedTable = true;
            $scope.copyTableMessage = copytable.response +
              ' Click here to proceed.';
            focus('failed-copy');
          }
        } else {
          $scope.failedCopiedTable = true;
          $scope.copyTableMessage = 'An error has occured.' +
            ' Please contact system administrator.' +
            ' Click here to proceed.';
          focus('failed-copy');
        }
      });
    };

    $scope.copyTableProceed = function (clearable) {
      if (Boolean(clearable)) {
        $scope.clearCopyTableForm();
      }
      $scope.failedCopiedTable = false;
      $scope.successCopiedTable = false;
      $scope.canCopyTable = true;
    };
    $scope.canEdit = function (user, request) {
      if (user.username() === request.createdBy) {
        return true;
      } else {
        return false;
      }
    };

    $scope.changeCommentType = function (request, radioValue) {
      $scope.request.commentType = radioValue;
      switch (radioValue) {
      case 2:
        $scope.generalIsChecked = true;
        $scope.operationIsChecked = false;
        break;
      case 1:
        $scope.generalIsChecked = false;
        $scope.operationIsChecked = true;
        break;
      }
    };

    $scope.getSelectedCommentType = function (value) {
      if ($scope.request.commentType === value && value === 2) {
        return true;
      } else if ($scope.request.commentType === value && value === 1) {
        return true;
      } else {
        return false;
      }
    };

    // $scope.loadRequest($routeParams.id);
    $scope.requestTypes();
    $scope.getDataTypes();
    $scope.getDataSources();
    $scope.loadRequestByID($routeParams.id);
    $scope.loadLogs($routeParams.id, $user.permissions());
  }
]);